package my.imageV;

/* 引入轻舟安卓开发框架的核心类 */
import com.simple.android.*;
import android.content.Context;
import android.view.View;
import android.graphics.Point;
import android.graphics.PointF;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import java.util.ArrayList;
import java.util.List;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;


public class 高清图片缩放 extends 视图 {

    SubsamplingScaleImageView imageView;
    private int 最大边限制 = -1;
    private float 默认缩放比例 = 1.0f;
    private int 当前旋转角度 = 0;
    private boolean 双击缩放启用 = true;
    
 
    private Paint 默认矩形画笔;
    private Paint 默认文字画笔;
        
    @Override
     /** 创建并返回可缩放的图片视图实例 */
    public View createView() {
        imageView = new SubsamplingScaleImageView(MainActivity.getContext());
 

 
        return imageView;
    }


     /** 配置视图默认参数：缩放类型、双击缩放、边界限制 */
    private void 配置默认参数() {
        // 默认自适应屏幕逻辑
        imageView.setMinimumScaleType(SubsamplingScaleImageView.SCALE_TYPE_CENTER_INSIDE);
        imageView.setDoubleTapZoomScale(1.5f);
        imageView.setPanLimit(SubsamplingScaleImageView.PAN_LIMIT_INSIDE);
        imageView.setZoomEnabled(双击缩放启用);
    }
   
    /** 
     * 设置图片显示路径 
     * @param path参数格式支持：http/https 网络图片 、file:// 本地文件 、 assets/ 内置资源文件
     */
    public void 设置图片路径(String path) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            // 使用兼容的图片加载方式
            imageView.setImage(ImageSource.uri(path));
        } else if (path.startsWith("assets/")) {
            try {
                imageView.setImage(ImageSource.asset(path.replace("assets/", "")));
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            imageView.setImage(ImageSource.uri(path.startsWith("file://") ? path.substring(7) : path));
        }
        
        if (最大边限制 != -1) {
            应用最大边限制();
        }
    
        
        // 应用最大边限制逻辑
        if (最大边限制 != -1) {
            应用最大边限制();
        }
    }
    
    //*直接传入bitmap位图，设置当前图片*/
    public void 设置图片(Bitmap bitmap) {
    imageView.setImage(ImageSource.bitmap(bitmap));  
    if (最大边限制 != -1) {
        应用最大边限制();
    }
    imageView.setOrientation(当前旋转角度);
}


    //**设置图片最大显示边长 最大像素值（-1表示禁用限制） */
    public void 设置最大边(int maxPixels) {
        最大边限制 = maxPixels;
        if (maxPixels != -1) {
            imageView.setMinimumScaleType(SubsamplingScaleImageView.SCALE_TYPE_CUSTOM);
            应用最大边限制();
        } else {
            imageView.setMinimumScaleType(SubsamplingScaleImageView.SCALE_TYPE_CENTER_INSIDE);
        }
    }

    /**
     * 配置双击缩放功能参数 
       启用 是否启用双击交互
       最小比例 允许的最小缩放级别
       最大比例 允许的最大缩放级别
     */
    public void 配置双击缩放(boolean 启用, float 最小比例, float 最大比例) {
        双击缩放启用 = 启用;
        imageView.setZoomEnabled(启用);
        imageView.setMinScale(最小比例);
        imageView.setMaxScale(最大比例);
        imageView.setDoubleTapZoomScale((最大比例 + 最小比例)/2); // 取中间值
    }

    /**旋转图片显示方向角度 旋转度数（90的整数倍）*/
    public void 旋转图片(int 角度) {
        当前旋转角度 = (当前旋转角度 + 角度) % 360;
        imageView.setOrientation(当前旋转角度);
        
        // 旋转后重新计算显示比例
        if (最大边限制 != -1) {
            应用最大边限制();
        }
    }

    /** 释放图片资源并重置状态 */
    public void 释放资源() {
        if (imageView != null) {
            imageView.recycle();
            imageView = null;
            最大边限制 = -1;
            当前旋转角度 = 0;
        }
    }

    //================ 私有计算逻辑 ================//
    private void 应用最大边限制() {
        imageView.setOnImageEventListener(new SubsamplingScaleImageView.OnImageEventListener() {
            @Override
            public void onReady() {}
            
            @Override
            public void onImageLoaded() {
                Point 原始尺寸 = new Point(imageView.getSWidth(), imageView.getSHeight());
                Point 显示尺寸 = 计算旋转后尺寸(原始尺寸, 当前旋转角度);
                
                float 适配比例 = Math.min(
                    (float)最大边限制 / 显示尺寸.x,
                    (float)最大边限制 / 显示尺寸.y
                );
                
                imageView.setMinScale(适配比例 * 0.8f);
                imageView.setMaxScale(适配比例 * 3.0f);
                imageView.setScaleAndCenter(适配比例, getImageCenter());
            }

            @Override
            public void onPreviewLoadError(Exception e) {}
            
            @Override
            public void onImageLoadError(Exception e) {}
            
            @Override
            public void onTileLoadError(Exception e) {}
            
            @Override
            public void onPreviewReleased() {}
        });
    }

    private Point 计算旋转后尺寸(Point 原始尺寸, int 旋转角度) {
        return (旋转角度 % 180 == 90) ? 
            new Point(原始尺寸.y, 原始尺寸.x) : 
            原始尺寸;
    }

    private PointF getImageCenter() {
        return new PointF(
            imageView.getSWidth() / 2f,
            imageView.getSHeight() / 2f
        );
    }
    
    
}
